<?php
// Endpoint URL
$url = 'https://api.xendit.co/payment_requests';

// Get the JSON request body sent by the client
$requestBody = json_decode(file_get_contents('php://input'), true);

// Extract the API key from the request body
$apiKey = $requestBody['apiKey'] ?? '';

// Remove the API key from the request body before sending to Xendit
unset($requestBody['apiKey']);

// Initialize cURL session
$ch = curl_init($url);

// Set cURL options
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, array(
    'Content-Type: application/json',
    'Authorization: Basic ' . base64_encode($apiKey . ':')
));
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($requestBody));

// Execute the cURL request
$response = curl_exec($ch);
$http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);

// Close the cURL session
curl_close($ch);

// Define the file to store all the responses
$filename = 'all_responses.json';

// Check if the response is successful (status code 201 for resource creation)
if ($http_status == 201) {
    // Decode the response data
    $response_data = json_decode($response, true);
    
    // Extract only the required data
    $saved_data = [
        'payment_method' => [
            'id' => $response_data['payment_method']['id'],
            'virtual_account' => $response_data['payment_method']['virtual_account']
        ],
        'timestamp' => date('Y-m-d H:i:s')
    ];
    
    // Read existing data or initialize an empty array
    $existing_data = file_exists($filename) ? json_decode(file_get_contents($filename), true) : [];
    
    // Append the new data
    $existing_data[] = $saved_data;
    
    // Save the updated data back to the file
    file_put_contents($filename, json_encode($existing_data, JSON_PRETTY_PRINT));
}

// Prepare the response array
$result = [
    'status' => $http_status,
    'response' => json_decode($response, true)
];

// Return the response to the client
header('Content-Type: application/json');
echo json_encode($result);